/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	PartClose.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//	Close the active part
HRESULT PartClose() 
{
	START_METHOD("PartClose")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// get the active part
	IGraphicDocument *activeGraphicDoc = NULL;
	status = pdApplication->GetActiveDoc(&activeGraphicDoc);
	CHECK_RETURN_STATUS(status)

	IPartDocument *activePart = CAST(IPartDocument, activeGraphicDoc);
	activePart->Release();

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IObject *object = CAST(IObject, pDesign);

	IFile *file = NULL;
	status = object->GetFile(&file);
	CHECK_RETURN_STATUS(status)

	BSTR str;
	status = file->GetName(&str);
	CString fileName(str);

	IPartOthers *part1 = CAST(IPartOthers, activePart);

	// close the part
	VARIANT_BOOL retval = FALSE;
	if(fileName.IsEmpty()) {
		BSTR tempStr = NULL;
		status = activeGraphicDoc->Close(tempStr, FALSE, &retval);
//		CHECK_RETURN_STATUS(status)
	}
	else {
		status = activeGraphicDoc->Close(fileName.AllocSysString(), TRUE, &retval);
		CHECK_RETURN_STATUS(status)
	}
	END_METHOD("PartClose")

}
